/*
BonsaiGUI
Copyright (C) 2003 Bj\"orn Hoffmeister

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package de.uni_luebeck.tcs.demo.datamining;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

import de.uni_luebeck.tcs.animation.*;


public class BonsaiGUI implements Animator.Listener {
    protected final static String EXAMPLE = "display example";
    protected final static String EXAMPLE_EDIT = "edit example";
    protected final static String INFO = "info";
    protected final static String INITIALIZE = "initialize animations";
    protected final static String PATTERN = "pattern";
    protected final static String TIMER = "timer";
    protected final static String GUESS = "guess";
    protected final static String GUESS_CHOICE = "make your choice";
    protected final static String EMPTY = "empty";

    protected static final String[] ABC = {
	"A", "B", "C", "D", "E", "F", "G", "H", "I"
    };

    protected static final String[] NON_TERMINAL = {
	"a", "b", "c", "d", "e", "f", "g", "h", "i", 
	"j", "k", "l", "m", "n", "o", "p", "q", "r", 
	"s", "t", "u", "v", "w", "x", "y", "z"
    };
    /*
    protected static final String[] NON_TERMINAL = {
	"x", "x", "x", "x", "x", "x", "x", "x", "x", 
	"x", "x", "x", "x", "x", "x", "x", "x", "x", 
	"x", "x", "x", "x", "x", "x", "x", "x"
    };
    */

    protected final static String[] DEFAULT_EXAMPLE = {
	"AKEBONO MUSASHIMARU",
	"CONTRIBUTIONS OF AI",
	"BASED ON LOCAL SEARCH ALGORITHMS",
	"BOOLEAN CLASSIFICATION",
	"SYMBOLIC TRANSFORMATION",
	"BACON SANDWICH",
	"PUBLICATION OF DISSERTATION"
    };

    protected final static String[] DEFAULT_ANSWER = {
	"TOY EXAMPLES",
	"WAKANOHANA TAKANOHANA",
	"BEYOND MESSY LEARNING",
	"GENETIC ALGORITHMS"
    };

    protected final static int ANIMATION_BASE_TIME = 2000;
    protected final static int ANIMATION_SENTENCE_TIME = 300;
    protected final static int ANIMATION_OFFSET = 500;
    protected final static int ANIMATION_SPEED_UP = 95; // Angabe in Prozent

    protected static final int NUMBER_OF_EXAMPLES = 9;
    // sollte <= 51 sein
    protected static final int MAX_EXAMPLE_LENGTH = 40;
    protected static final int NUMBER_OF_GUESSES = 4;

    protected static final Color GUESS_CLR = Color.orange;
    protected static final Color CORRECT_CLR = Color.green;
    protected static final Color INCORRECT_CLR = Color.red;

    //	int gridx, int gridy, int gridwidth, int gridheight, 
    //	double weightx, double weighty, 
    //	int anchor, int fill, 
    //	Insets insets, int ipadx, int ipady
    protected final GridBagConstraints gbcHead = new GridBagConstraints(
	GridBagConstraints.RELATIVE, GridBagConstraints.RELATIVE, GridBagConstraints.REMAINDER, 1,
	1.0, 0.0,
	GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL,
	new Insets(0, 0, 6, 0), 0, 0
    );
    protected final GridBagConstraints gbcCounter = new GridBagConstraints(
	0, GridBagConstraints.RELATIVE, 1, 1,
	0.0, 0.0,
	GridBagConstraints.NORTHEAST, GridBagConstraints.NONE,
	new Insets(0, 0, 3, 3), 0, 0
    );
    protected final GridBagConstraints gbcSentence = new GridBagConstraints(
	1, GridBagConstraints.RELATIVE, GridBagConstraints.REMAINDER, 1,
	1.0, 0.0,
	GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL,
	new Insets(0, 0, 3, 0), 0, 0
    );
    protected final GridBagConstraints gbcBordered = new GridBagConstraints(
	0, GridBagConstraints.RELATIVE, GridBagConstraints.REMAINDER, 1,
	1.0, 0.0,
	GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL,
	new Insets(3, 0, 3, 0), 0, 0
    );
    protected final GridBagConstraints gbcVerticalGlue = new GridBagConstraints(
	0, GridBagConstraints.RELATIVE, GridBagConstraints.REMAINDER, 1,
	0.0, 2.0,
	GridBagConstraints.CENTER, GridBagConstraints.VERTICAL,
	new Insets(0, 0, 0, 0), 0, 0
    );


    protected String[] strExample;
    protected String[] strMatch;
    protected String[] strNotMatch;
    protected int[] intGuessIndex;

    protected JComponent jpcContentPane;

    protected JLabel[][] jlbT;
    protected JLabel[][] jlbN;
    protected JLabel[] jlbPatternT;
    protected JLabel[] jlbPatternN;

    protected JTextField[] jtfSentence;
    protected JLabel[] jlbCounter;
    protected JPanel[] jplSentence;
    protected JFileChooser jfcOpen;
    protected JTextArea jtaInfo;
    //    protected String[] strInfo;
    protected JLabel jlbTimer;
    protected JPanel jplPattern;
    protected JProgressBar jpbInitialize;
    protected JLabel jlbGuessChoiceHead;
    protected JLabel jlbGuessDisplayHead;
    protected JLabel[] jbtGuess;
    protected JPanel[] jplGuess;

    protected CardLayout cdlExamplePane;
    protected CardLayout cdlPatternPane;
    protected CardLayout cdlGuessPane;
    protected JPanel jplExamplePane;
    protected JPanel jplPatternPane;    
    protected JPanel jplGuessPane;
    protected Color clrGuess;
    protected int intGuess;
    protected int intCorrectGuess;
    protected long lngTimedOut;

    protected Animator amtThis;
    protected AnimationFactory amfThis;
    protected AnimationFactory.StringAnimation[] sanCorrect;
    protected AnimationFactory.StringAnimation[] sanIncorrect;

    protected Font fntExample;
    protected Font fntTimer;
    protected Font fntGuessOutcome;
    protected Font fntPatternT;
    protected Font fntPatternN;
    protected Color clrT;
    protected Color clrN;
    protected Color clrBright;

    protected final Random rand;
    protected final Bonsai bnsExample;
    protected final PatternGenerator pgnGuess;

    protected static final int INIT = 0;
    protected static final int BEGIN = 1;
    protected static final int RANDOM = 2;
    protected static final int GUESS_ANIMATION = 3;
    protected static final int ANIMATION = 4;
    protected static final int IDLE = 5;
    protected static final int USER = 6;
    protected int intState = INIT;
    
    protected final static long GUESS_TIME = 120000;
    protected final static int WAIT_TIME = 180000;
    protected final javax.swing.Timer tmrIdle;
    protected final javax.swing.Timer tmrWait;
    protected final ActionListener aclInterrupt;

    protected boolean blnPause = false;
    protected long lngPausedTimeMillis;

    protected final boolean blnBeginAnimation;


    public BonsaiGUI() { this(true); }	

    public BonsaiGUI(boolean blnBeginAnimation) {
	//	super("Bonsai");
	setLandF();
	this.blnBeginAnimation = blnBeginAnimation;
	this.rand = new Random(System.currentTimeMillis());
	this.bnsExample = new Bonsai();
	this.pgnGuess = new PatternGenerator();
	pgnGuess.setNumberOfExamples(5, NUMBER_OF_EXAMPLES);
	pgnGuess.setStringLength(MAX_EXAMPLE_LENGTH);
	pgnGuess.setPatternLength((MAX_EXAMPLE_LENGTH / 4), 3 * (MAX_EXAMPLE_LENGTH / 4));

	// timer
	this.tmrWait = new javax.swing.Timer(1000, new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    timerStep();
		}
	    });
	this.tmrIdle = new javax.swing.Timer(WAIT_TIME, new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    random();
		}
	    });
	tmrIdle.setRepeats(false);

	// action listener
	aclInterrupt = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    interrupt();
		}
	    };

	//	strGuess = DEFAULT_ANSWER;
	//	setContentPane(buildContentPane());
	//	pack();
	this.jpcContentPane = buildContentPane();
	cdlExamplePane.show(jplExamplePane, EMPTY);
	cdlPatternPane.show(jplPatternPane, INITIALIZE);
	cdlGuessPane.show(jplGuessPane, EMPTY);	    
    }

    public String getName() {
	return "Pattern Learner";
    }

    public Component getComponent() {
        return jpcContentPane;
    }

    public void init() {	
	intState = INIT;
	if (blnBeginAnimation) initBeginAnimation();
	initGuessAnimation();

	jpbInitialize.setValue(100);
	jpbInitialize.setString("(100%)");
    }

    protected void initBeginAnimation() {
	jpbInitialize.setValue(0);
	jpbInitialize.setString("start animation (0%)");
	String strBegin = "BONSAI";
	Font fntNinety = amfThis.getFontForWidth(strBegin, fntGuessOutcome, 75);
	Font fntDoubleNinety = new Font(fntNinety.getFamily(), fntNinety.getStyle(), (5 * fntNinety.getSize()) / 2 - 1);	
	AnimationFactory.StringAnimation sanIn = amfThis.createStringGrowInAndOut
	    (strBegin, Color.red, fntNinety, 0);
	
	jpbInitialize.setValue(25);
	jpbInitialize.setString("start animation (25%)");
	AnimationFactory.StringAnimation sanOut = amfThis.createStringRotateOut
	    (strBegin, Color.red, fntDoubleNinety, sanIn.getRunningTime());
	amtThis.add(sanIn);
	amtThis.add(sanOut);
    }

    protected void initGuessAnimation() {
	// correct
	jpbInitialize.setValue(50);
	jpbInitialize.setString("\"Richtig\" animation (50%)");
	sanCorrect = new AnimationFactory.StringAnimation[2];
	String strCorrect = "Richtig";
	Font fntNinety = amfThis.getFontForWidth(strCorrect, fntGuessOutcome, 75);
	sanCorrect[0] = amfThis.createStringGrowIn
	    (strCorrect, CORRECT_CLR, fntNinety, 0);
	sanCorrect[1] = amfThis.createStringRotateOut
	    (strCorrect, CORRECT_CLR, fntNinety, sanCorrect[0].getRunningTime());

	// incorrect
	jpbInitialize.setValue(75);
	jpbInitialize.setString("\"Falsch\" animation (75%)");
	sanIncorrect = new AnimationFactory.StringAnimation[2];
	String strIncorrect = "Falsch";
	fntNinety = amfThis.getFontForWidth(strIncorrect, fntGuessOutcome, 75);
	sanIncorrect[0] = amfThis.createStringFallIn
	    (strIncorrect, INCORRECT_CLR, fntNinety, 0);
	sanIncorrect[1] = amfThis.createStringDropOut
	    (strIncorrect, INCORRECT_CLR, fntNinety, sanIncorrect[0].getRunningTime());
    }       

    public void start() {
	intState = BEGIN;
	if (blnBeginAnimation) {
	    cdlExamplePane.show(jplExamplePane, EXAMPLE);
	    cdlPatternPane.show(jplPatternPane, PATTERN);
	    cdlGuessPane.show(jplGuessPane, GUESS);	    
	    amtThis.start();
	} else {
	    animationEnded();
	}
    }

    public void pause() {	
	this.blnPause = true;

	switch (intState) {
	case RANDOM:
	    this.tmrWait.stop();
	    this.lngPausedTimeMillis = System.currentTimeMillis();
	    break;
	case IDLE:
	case USER:
	    this.tmrIdle.stop();
	    break;
	case BEGIN:
	case GUESS_ANIMATION:
	case ANIMATION:
	    amtThis.pause();
	    
	}
    }

    public void resume() {
	this.blnPause = false;

	switch (intState) {
	case RANDOM:
	    this.lngTimedOut += (System.currentTimeMillis() - lngPausedTimeMillis);
	    this.tmrWait.start();
	    break;
	case IDLE:
	case USER:
	    this.tmrIdle.start();
	    break;
	case BEGIN:
	case GUESS_ANIMATION:
	case ANIMATION:
	    amtThis.resume();
	}
    }

    protected void setLandF() {
	Font fntCurrent = (new JLabel()).getFont();
	String strFamily = fntCurrent.getFamily();
	this.fntExample = new Font(strFamily, Font.BOLD, 14);
	this.fntTimer = new Font(strFamily, Font.PLAIN, 14);
	this.fntGuessOutcome = new Font(strFamily, Font.BOLD, 14);
	this.fntPatternT = fntExample;
	this.fntPatternN = new Font(strFamily, Font.ITALIC, 14);

	this.clrT = Color.red;
	this.clrN = Color.black;
	this.clrBright = new Color(128, 128, 128);
	this.clrGuess = Color.yellow.darker();
    }
        
    protected JComponent buildContentPane() {
	buildExamplePane();
	buildPatternPane();
	buildGuessPane();
	JPanel jplVerticalGlue = new JPanel();

	GridBagLayout gblContent = new GridBagLayout();
	gblContent.setConstraints(jplExamplePane, gbcBordered);
	gblContent.setConstraints(jplPatternPane, gbcBordered);
	gblContent.setConstraints(jplGuessPane, gbcBordered);
	gblContent.setConstraints(jplVerticalGlue, gbcVerticalGlue);
	JPanel bplContent = new JPanel(gblContent);
	bplContent.add(jplVerticalGlue);
	bplContent.add(jplExamplePane);
	bplContent.add(jplPatternPane);
	bplContent.add(jplGuessPane);
	bplContent.add(jplVerticalGlue);

	amtThis = new Animator(bplContent, true);
	amtThis.addAnimatorListener(this);
	amfThis = new AnimationFactory(amtThis);

	JComponent jpcContentPane = amtThis.getAnimatorPane();
	jpcContentPane.setMaximumSize(jpcContentPane.getPreferredSize());

	return jpcContentPane;
    }

    protected JPanel buildExamplePane() {
	StringBuffer stbReference = new StringBuffer(MAX_EXAMPLE_LENGTH + 4);
	for (int i = 0; i < MAX_EXAMPLE_LENGTH + 4; i++) stbReference.append("X");
	String strReference = stbReference.toString();

	GridBagLayout gblExampleEdit = new GridBagLayout();
	JPanel jplExampleEdit = new JPanel(gblExampleEdit);
	jplExampleEdit.setFont(fntExample);
	this.jtfSentence = new JTextField[NUMBER_OF_EXAMPLES];
	for (int i = 0; i < jtfSentence.length; i++) {
	    JLabel jlbCounter = new JLabel((i + 1) + ". ", JLabel.RIGHT);	    
	    jtfSentence[i] = new JTextField(MAX_EXAMPLE_LENGTH);
	    jtfSentence[i].setFont(fntExample);
	    jtfSentence[i].setText(strReference);
	    jtfSentence[i].setPreferredSize(jtfSentence[i].getPreferredSize());
	    gblExampleEdit.setConstraints(jlbCounter, gbcCounter);
	    gblExampleEdit.setConstraints(jtfSentence[i], gbcSentence);
	    jplExampleEdit.add(jlbCounter);
	    jplExampleEdit.add(jtfSentence[i]);
	}

	GridBagLayout gblExampleDisplay = new GridBagLayout();
	JPanel jplExampleDisplay = new JPanel(gblExampleDisplay);
	jplExampleDisplay.setFont(fntExample);
	this.jlbCounter = new JLabel[NUMBER_OF_EXAMPLES];
	this.jplSentence = new JPanel[NUMBER_OF_EXAMPLES];
	for (int i = 0; i < jplSentence.length; i++) {
	    jlbCounter[i] = new JLabel((i + 1) + ". ", JLabel.RIGHT);
	    jplSentence[i] = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
	    jplSentence[i].setPreferredSize(jtfSentence[i].getPreferredSize());
	    jplSentence[i].setBorder(jtfSentence[i].getBorder());
	    jplSentence[i].add(new JLabel(" "));
	    gblExampleDisplay.setConstraints(jlbCounter[i], gbcCounter);
	    gblExampleDisplay.setConstraints(jplSentence[i], gbcSentence);
	    jplExampleDisplay.add(jlbCounter[i]);
	    jplExampleDisplay.add(jplSentence[i]);
	}
	
	this.jtaInfo = new JTextArea();
	jtaInfo.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
	jtaInfo.setBackground(Color.black);
	jtaInfo.setForeground(Color.green.darker());
	jtaInfo.setFont(new Font("Monospaced", Font.PLAIN, jtaInfo.getFont().getSize()));
	jtaInfo.setEditable(false);
	jtaInfo.setLineWrap(true);
	jtaInfo.setPreferredSize(jplExampleEdit.getPreferredSize());
	jtaInfo.append("> _");

	JPanel jplInfo = new JPanel(new BorderLayout());
	jplInfo.setBorder(BorderFactory.createCompoundBorder(
	    BorderFactory.createEmptyBorder(0, 0, 3, 0),
	    BorderFactory.createLoweredBevelBorder()
	));
	jplInfo.add(jtaInfo, BorderLayout.CENTER);	
	

	JButton jbtRandom = new JButton("Zufall");
	Dimension dimButton = jbtRandom.getPreferredSize();
	int intWidth = dimButton.width, intHeight = dimButton.height;
	jbtRandom.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    randomExample();
		}
	    });

	JButton jbtOpen = new JButton("ffnen");
	dimButton = jbtOpen.getPreferredSize();
	intWidth = Math.max(intWidth, dimButton.width);
	intHeight = Math.max(intHeight, dimButton.height);
	try {
	    this.jfcOpen = new JFileChooser();
	    //	jfcOpen.setAcceptAllFileFilterUsed(false);
	    jfcOpen.setFileFilter(new javax.swing.filechooser.FileFilter() {
		    public boolean accept(File filAccept) {
			return filAccept.isDirectory() || filAccept.getName().endsWith(".data");
		    }

		    public String getDescription() {
			return "Bonsai-Filter";
		    }
		});
	    jbtOpen.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			openExample();
		    }
		});
	    jbtOpen.addActionListener(aclInterrupt);
	} catch(SecurityException e) {
	    jbtOpen.setEnabled(false);
	}

	JButton jbtEdit = new JButton("Bearbeiten");
	dimButton = jbtEdit.getPreferredSize();
	intWidth = Math.max(intWidth, dimButton.width);
	intHeight = Math.max(intHeight, dimButton.height);
	jbtEdit.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    editExample();
		}
	    });
	jbtEdit.addActionListener(aclInterrupt);

	JButton jbtEditClear = new JButton("Lschen");
	dimButton = jbtEditClear.getPreferredSize();
	intWidth = Math.max(intWidth, dimButton.width);
	intHeight = Math.max(intHeight, dimButton.height);
	jbtEditClear.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    clearEditExample();
		}
	    });
	jbtEditClear.addActionListener(aclInterrupt);

	JButton jbtEditOk = new JButton("OK");
	dimButton = jbtEditOk.getPreferredSize();
	intWidth = Math.max(intWidth, dimButton.width);
	intHeight = Math.max(intHeight, dimButton.height);
	jbtEditOk.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    confirmEditExample();
		}
	    });
	jbtEditOk.addActionListener(aclInterrupt);

	JButton jbtEditCancel = new JButton("Abbrechen");
	dimButton = jbtEditCancel.getPreferredSize();
	intWidth = Math.max(intWidth, dimButton.width);
	intHeight = Math.max(intHeight, dimButton.height);
	jbtEditCancel.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    cancelEditExample();
		}
	    });
	jbtEditCancel.addActionListener(aclInterrupt);

	JButton jbtInfoOk = new JButton("OK");
	dimButton = jbtInfoOk.getPreferredSize();
	intWidth = Math.max(intWidth, dimButton.width);
	intHeight = Math.max(intHeight, dimButton.height);
	jbtInfoOk.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    confirmInfo();
		}
	    });

	dimButton = new Dimension((3 * intWidth) / 2, intHeight);
 	jbtRandom.setPreferredSize(dimButton);
 	jbtRandom.setMaximumSize(dimButton);
	jbtOpen.setPreferredSize(dimButton);
	jbtOpen.setMaximumSize(dimButton);
	jbtEdit.setPreferredSize(dimButton);
	jbtEdit.setMaximumSize(dimButton);
	jbtEditClear.setPreferredSize(dimButton);
	jbtEditClear.setMaximumSize(dimButton);
	jbtEditOk.setPreferredSize(dimButton);
	jbtEditOk.setMaximumSize(dimButton);
	jbtEditCancel.setPreferredSize(dimButton);
	jbtEditCancel.setMaximumSize(dimButton);
	jbtInfoOk.setPreferredSize(dimButton);
	jbtInfoOk.setMaximumSize(dimButton);

	MouseListener mlsInfo = new MouseListener() {
		public void mouseClicked(MouseEvent e) {
		    showInfo();
		}
		public void mouseEntered(MouseEvent e) {
		    
		}
		public void mouseExited(MouseEvent e) {}
		public void mousePressed(MouseEvent e) {}
		public void mouseReleased(MouseEvent e) {}
	    };

	JLabel jbtInfo = new JLabel("i", JLabel.CENTER);
	jbtInfo.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	jbtInfo.addMouseListener(mlsInfo);
	JLabel jbtEditInfo = new JLabel("i", JLabel.CENTER);
	jbtEditInfo.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	jbtEditInfo.addMouseListener(mlsInfo);

	Dimension dimTmp = jlbCounter[jlbCounter.length - 1].getPreferredSize();
	dimButton = new Dimension(dimTmp.width, dimButton.height);
	jbtInfo.setPreferredSize(dimButton);
	jbtInfo.setMaximumSize(dimButton);
	jbtEditInfo.setPreferredSize(dimButton);
	jbtEditInfo.setMaximumSize(dimButton);
	Font fntInfo = new Font(jbtInfo.getFont().getFamily(), Font.ITALIC + Font.BOLD, jbtInfo.getFont().getSize() + 2);
	jbtInfo.setFont(fntInfo);
	jbtEditInfo.setFont(fntInfo);

	
	JPanel jplButton = new JPanel(new FlowLayout(FlowLayout.RIGHT, 3, 3));
	jplButton.add(jbtRandom);
	jplButton.add(jbtOpen);
	jplButton.add(jbtEdit);
	
	Box boxButton = Box.createHorizontalBox();
	boxButton.add(jbtInfo);
	boxButton.add(Box.createHorizontalStrut(3));
	boxButton.add(Box.createHorizontalGlue());
	boxButton.add(jbtRandom);
	boxButton.add(Box.createHorizontalStrut(3));
	boxButton.add(jbtOpen);
	boxButton.add(Box.createHorizontalStrut(3));
	boxButton.add(jbtEdit);

	JPanel jplExampleDisplayPane = new JPanel(new BorderLayout());
	jplExampleDisplayPane.add(jplExampleDisplay, BorderLayout.CENTER);
	jplExampleDisplayPane.add(boxButton, BorderLayout.SOUTH);

	boxButton = Box.createHorizontalBox();
	boxButton.add(jbtEditInfo);
	boxButton.add(Box.createHorizontalStrut(3));
	boxButton.add(jbtEditClear);	
	boxButton.add(Box.createHorizontalStrut(3));
	boxButton.add(Box.createHorizontalGlue());
	boxButton.add(jbtEditOk);
	boxButton.add(Box.createHorizontalStrut(3));
	boxButton.add(jbtEditCancel);

	jplExampleDisplayPane.setBorder(BorderFactory.createCompoundBorder(
            BorderFactory.createTitledBorder("Beispiele"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));

	JPanel jplExampleEditPane = new JPanel(new BorderLayout());
	jplExampleEditPane.add(jplExampleEdit, BorderLayout.CENTER);
	jplExampleEditPane.add(boxButton, BorderLayout.SOUTH);

	boxButton = Box.createHorizontalBox();
	boxButton.add(Box.createHorizontalGlue());
	boxButton.add(jbtInfoOk);
	
	jplExampleEditPane.setBorder(BorderFactory.createCompoundBorder(
            BorderFactory.createTitledBorder("Beispiele"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));

	JPanel jplInfoPane = new JPanel(new BorderLayout());
	jplInfoPane.add(jplInfo, BorderLayout.CENTER);
	jplInfoPane.add(boxButton, BorderLayout.SOUTH);

	jplInfoPane.setBorder(BorderFactory.createCompoundBorder(
            BorderFactory.createTitledBorder("Info-Shell"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));

	jplExampleDisplayPane.setMinimumSize(jplExampleEditPane.getPreferredSize());
	jplExampleDisplayPane.setPreferredSize(jplExampleEditPane.getPreferredSize());
	jplExampleDisplayPane.setMaximumSize(jplExampleEditPane.getPreferredSize());
	jplExampleEditPane.setMinimumSize(jplExampleEditPane.getPreferredSize());
	jplExampleEditPane.setPreferredSize(jplExampleEditPane.getPreferredSize());
	jplExampleEditPane.setMaximumSize(jplExampleEditPane.getPreferredSize());
	jplInfoPane.setMinimumSize(jplExampleEditPane.getPreferredSize());
	jplInfoPane.setPreferredSize(jplExampleEditPane.getPreferredSize());
	jplInfoPane.setMaximumSize(jplExampleEditPane.getPreferredSize());

	JPanel jplEmpty = new JPanel(null);
	jplEmpty.setPreferredSize(jplExampleDisplayPane.getPreferredSize());

	this.cdlExamplePane = new CardLayout();
	this.jplExamplePane = new JPanel(cdlExamplePane);
	jplExamplePane.add(jplExampleDisplayPane, EXAMPLE);
	jplExamplePane.add(jplExampleEditPane, EXAMPLE_EDIT);	
	jplExamplePane.add(jplInfoPane, INFO);
	jplExamplePane.add(jplEmpty, EMPTY);

	return jplExamplePane;
    }

    protected JPanel buildPatternPane() {
	JLabel jlbCounter = new JLabel(jtfSentence.length + ". ", JLabel.RIGHT);
	jlbCounter.setForeground(jlbCounter.getBackground());
	this.jpbInitialize = new JProgressBar(0, 100);
	jpbInitialize.setStringPainted(true);
	jpbInitialize.setPreferredSize(jtfSentence[0].getPreferredSize());

	GridBagLayout gblInitialize = new GridBagLayout();
	JPanel jplInitialize = new JPanel(gblInitialize);
	gblInitialize.setConstraints(jlbCounter, gbcCounter);
	gblInitialize.setConstraints(jpbInitialize, gbcSentence);
	jplInitialize.add(jlbCounter);
	jplInitialize.add(jpbInitialize);
	jplInitialize.setBorder(BorderFactory.createCompoundBorder(
	    BorderFactory.createTitledBorder("Initialisiere"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));

	this.jlbTimer = new JLabel("0:00", JLabel.CENTER);	
	jlbTimer.setFont(fntTimer);

	jlbCounter = new JLabel(jtfSentence.length + ". ", JLabel.RIGHT);
	jlbCounter.setForeground(jlbCounter.getBackground());
	this.jplPattern = new JPanel(new FlowLayout(FlowLayout.LEFT, 2, 0));
	jplPattern.setPreferredSize(jtfSentence[0].getPreferredSize());

	GridBagLayout gblPatternDisplay = new GridBagLayout();
	JPanel jplPatternDisplay = new JPanel(gblPatternDisplay);	
	gblPatternDisplay.setConstraints(jlbCounter, gbcCounter);
	gblPatternDisplay.setConstraints(jplPattern, gbcSentence);
	jplPatternDisplay.add(jlbCounter);
	jplPatternDisplay.add(jplPattern);
	jplPatternDisplay.setBorder(BorderFactory.createCompoundBorder(
	    BorderFactory.createTitledBorder("Pattern"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));

	JPanel jplPatternEmpty = new JPanel(null);
	jplPatternEmpty.setPreferredSize(jplPatternDisplay.getPreferredSize());

	this.cdlPatternPane = new CardLayout();
	this.jplPatternPane = new JPanel(cdlPatternPane);
	jplPatternPane.add(jplInitialize, INITIALIZE);
	jplPatternPane.add(jplPatternDisplay, PATTERN);
	jplPatternPane.add(jlbTimer, TIMER);
	jplPatternPane.add(jplPatternEmpty, EMPTY);

	return jplPatternPane;
    }

    protected JPanel buildGuessPane() {
	Dimension dimCounter = jlbCounter[jlbCounter.length - 1].getPreferredSize();
	Dimension dimGuess = jtfSentence[0].getPreferredSize();
	Border brdGuess = jtfSentence[0].getBorder();

	GridBagLayout gblGuessChoice = new GridBagLayout();
	JPanel jplGuessChoice = new JPanel(gblGuessChoice);
	this.jlbGuessChoiceHead = new JLabel(" ", JLabel.LEFT);
	gblGuessChoice.setConstraints(jlbGuessChoiceHead, gbcHead);
	jplGuessChoice.add(jlbGuessChoiceHead);
	jplGuessChoice.setFont(fntExample);
	this.jbtGuess = new JLabel[NUMBER_OF_GUESSES];
	for (int i = 0; i < jbtGuess.length; i++) {
	    JLabel jlbCounter = new JLabel(ABC[i] + ". ", JLabel.RIGHT);
	    //	    jlbCounter.setPreferredSize(dimCounter);	    
	    jbtGuess[i] = new JLabel();
	    jbtGuess[i].setPreferredSize(dimGuess);
	    jbtGuess[i].setBorder(brdGuess);
	    jbtGuess[i].setHorizontalAlignment(JLabel.LEFT);
	    jbtGuess[i].setFont(fntExample);
	    final int intGuess = i;
	    jbtGuess[i].addMouseListener(new MouseAdapter() {
		    public void mouseClicked(MouseEvent e) {
			guess(intGuess);
		    }
		});
	    gblGuessChoice.setConstraints(jlbCounter, gbcCounter);
	    gblGuessChoice.setConstraints(jbtGuess[i], gbcSentence);
	    jplGuessChoice.add(jlbCounter);
	    jplGuessChoice.add(jbtGuess[i]);
	}
	jplGuessChoice.setBorder(BorderFactory.createCompoundBorder(
	    BorderFactory.createTitledBorder("Anwort"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));

	GridBagLayout gblGuessDisplay = new GridBagLayout();
	JPanel jplGuessDisplay = new JPanel(gblGuessDisplay);
	this.jlbGuessDisplayHead = new JLabel(" ", JLabel.LEFT);
	gblGuessDisplay.setConstraints(jlbGuessDisplayHead, gbcHead);
	jplGuessDisplay.add(jlbGuessDisplayHead);
	brdGuess = jtfSentence[0].getBorder();
	jplGuessDisplay.setFont(fntExample);
	this.jplGuess = new JPanel[NUMBER_OF_GUESSES];
	for (int i = 0; i < jplGuess.length; i++) {
	    JLabel jlbCounter = new JLabel(ABC[i] + ". ", JLabel.RIGHT);
	    //	    jlbCounter.setPreferredSize(dimCounter);
	    jplGuess[i] = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
	    jplGuess[i].setPreferredSize(dimGuess);
	    jplGuess[i].setBorder(brdGuess);
	    gblGuessDisplay.setConstraints(jlbCounter, gbcCounter);
	    gblGuessDisplay.setConstraints(jplGuess[i], gbcSentence);
	    jplGuessDisplay.add(jlbCounter);
	    jplGuessDisplay.add(jplGuess[i]);
	}
	jplGuessDisplay.setBorder(BorderFactory.createCompoundBorder(
	    BorderFactory.createTitledBorder("Antwort"),
	    BorderFactory.createEmptyBorder(6, 6, 6, 6)
	));
	this.clrGuess = jplGuess[0].getBackground();

	JPanel jplGuessEmpty = new JPanel(null);
	jplGuessEmpty.setPreferredSize(jplGuessChoice.getPreferredSize());

	this.cdlGuessPane = new CardLayout();
	this.jplGuessPane = new JPanel(cdlGuessPane);
	jplGuessPane.add(jplGuessChoice, GUESS_CHOICE);
	jplGuessPane.add(jplGuessDisplay, GUESS);	
	jplGuessPane.add(jplGuessEmpty, EMPTY);	

	return jplGuessPane;
    }

    protected void randomExample() {
	random();
    }

    protected void openExample() {
	if (jfcOpen.showDialog(jpcContentPane, "ffnen") != JFileChooser.APPROVE_OPTION) return;
	
	File filIn = jfcOpen.getSelectedFile();
	BufferedReader bfrIn = null;
	ArrayList altIn = new ArrayList(NUMBER_OF_EXAMPLES);
	try {
	    bfrIn = new BufferedReader(new FileReader(filIn));
	    String strIn;
	    while ((strIn = bfrIn.readLine()) != null) altIn.add(strIn);
	} catch (Exception e) {
	    displayWarning("Fehler beim Lesen von Datei \"" + filIn + "\":"
		+ e.getMessage());
	}
	try { bfrIn.close(); } catch(Exception e) {}
	String[] strExample = new String[altIn.size()];
	for (int i =0; i < strExample.length; i++) strExample[i] = (String)altIn.get(i);
	setUserExample(strExample);		    
    }

    protected void editExample() {
	for (int i = 0; i < strExample.length; i++) jtfSentence[i].setText(strExample[i]);
	for (int i = strExample.length; i < NUMBER_OF_EXAMPLES; i++) jtfSentence[i].setText("");
	cdlExamplePane.show(jplExamplePane, EXAMPLE_EDIT);	    
    }

    protected void clearEditExample() {
	for (int i = 0; i < jtfSentence.length; i++) jtfSentence[i].setText("");
    }

    protected void confirmEditExample() {
	int j = jtfSentence.length;
	for (int i = jtfSentence.length - 1; i >= 0; i--) 
	    if (jtfSentence[i].getText().length() == 0) j--;
	    else break;
	String[] strExample = new String[j];	
	for (int i = 0; i < j; i++) strExample[i] = jtfSentence[i].getText();
	setUserExample(strExample);
    }

    protected void cancelEditExample() {
	cdlExamplePane.show(jplExamplePane, EXAMPLE);	    
    }
    
    protected void showInfo() {
	cdlExamplePane.show(jplExamplePane, INFO);	    
    }

    protected void confirmInfo() {
	cdlExamplePane.show(jplExamplePane, EXAMPLE);	    
    }

    protected void timerStep() {
	if (intState != RANDOM) return;

	long lngRunTime = lngTimedOut - System.currentTimeMillis();
	if (lngRunTime < 1000) {
	    guessSolution();
	} else {
	    lngRunTime /= 1000;
	    long lngMinutes = lngRunTime / 60;
	    long lngSeconds = lngRunTime % 60;
	    jlbTimer.setText(lngMinutes + ((lngSeconds < 10)?":0" + lngSeconds:":" + lngSeconds));
	    // jlbTimer.repaint();
	}
    }

    protected void buildResult() {
	for (int i = 0; i < jplSentence.length; i++) jplSentence[i].removeAll();
	jplPattern.removeAll();
	for (int i = 0; i < jplGuess.length; i++) {
	    jplGuess[i].removeAll();
	    jplGuess[i].setBackground(clrGuess);
	}

	//	String[] strExample = bnsExample.getData();
	int[][] intTable = bnsExample.getIndexTable();
	String strPattern = bnsExample.getResult();
	boolean[] blnType = bnsExample.getResultType();

	// Example
	// Initialisierung
	int intT = 0; int intN = 0;
	for (int i = 0; i < blnType.length; i++) if (blnType[i]) intT++; else intN++;
	this.jlbT = new JLabel[intT][strExample.length + ((strMatch != null)?strMatch.length:0)];
	this.jlbN = new JLabel[intN][strExample.length + ((strMatch != null)?strMatch.length:0)];
	
	// Aufbau
	for (int i = 0; i < strExample.length; i++) {
	    int k = 0; int l = 0; int intBegin = 0;
	    if (!blnType[0]) {
		if (intTable[0][i] == 0) {
		    jlbN[0][i] = null;
		} else if (intTable[0][i] == Integer.MAX_VALUE) {
		    jlbN[0][i] = new JLabel(strExample[i]);
		} else {
		    jlbN[0][i] = new JLabel(strExample[i].substring(0, intTable[0][i]));
		}
		if (jlbN[0][i] != null) {
		    jlbN[0][i].setFont(fntExample);
		    jplSentence[i].add(jlbN[0][i]);
		}			
		l++;
		intBegin = 1;
	    }
	    for (int j = intBegin; j < blnType.length; j++) {
		if (blnType[j]) {
		    jlbT[k][i] = new JLabel(strExample[i].substring(intTable[k][i], intTable[k][i] + 1));
		    jlbT[k][i].setFont(fntExample);
		    jplSentence[i].add(jlbT[k][i]);
		    k++;
		} else {
		    if (intTable[k][i] == Integer.MAX_VALUE) {
			if (intTable[k - 1][i] == strExample[i].length() - 1) {
			    jlbN[l][i] = null;
			} else {
			    jlbN[l][i] = new JLabel(strExample[i].substring(intTable[k - 1][i] + 1));
			}
		    } else {
			if (intTable[k][i] - intTable[k - 1][i] == 1) {
			    jlbN[l][i] = null;
			} else {
			    jlbN[l][i] = new JLabel(strExample[i].substring(intTable[k - 1][i] + 1, intTable[k][i]));
			}
		    }
		    if (jlbN[l][i] != null) {
			jlbN[l][i].setFont(fntExample);
			jplSentence[i].add(jlbN[l][i]);
		    }			
		    l++;
		}
		//		jlbCounter[i].setForeground(jlbCounter[0].getForeground());
	    }
	}

	for (int i = strExample.length; i < NUMBER_OF_EXAMPLES; i++) {
	    //	    jplSentence[i].add(new JLabel(" "));
	    //	    jlbCounter[i].setForeground(jlbCounter[i].getBackground());
	}

	


	// Pattern
	// Initialisierung
	this.jlbPatternT = new JLabel[intT];
	this.jlbPatternN = new JLabel[intN];

	// Aufbau
	int k = 0; int l = 0;
	for (int j = 0; j < blnType.length; j++) {
	    if (blnType[j]) {
		jlbPatternT[k] = new JLabel(strPattern.substring(j, j + 1));
		jlbPatternT[k].setFont(fntPatternT);
		jlbPatternT[k].setForeground(jlbPatternT[k].getBackground());
		jplPattern.add(jlbPatternT[k]);
		k++;
	    } else {
		jlbPatternN[l] = new JLabel(NON_TERMINAL[NON_TERMINAL.length - intN + l]);
		jlbPatternN[l].setFont(fntPatternN);
		jlbPatternN[l].setForeground(jlbPatternN[l].getBackground());
		jplPattern.add(jlbPatternN[l]);
		l++;
	    }
	}
	
	if (strMatch != null) {
	    // Antwort
	    // Initialisierung
	    int intOffset = strExample.length;
	    intTable = pgnGuess.getIndexTable();

	    // Aufbau
	    for (int i = 0; i < strMatch.length; i++) {
		k = 0; l = 0; int intBegin = 0;
		if (!blnType[0]) {
		    if (intTable[0][i] == 0) {
			jlbN[0][intOffset + i] = null;
		    } else if (intTable[0][i] == Integer.MAX_VALUE) {
			jlbN[0][intOffset + i] = new JLabel(strMatch[i]);
		    } else {
			jlbN[0][intOffset + i] = new JLabel(strMatch[i].substring(0, intTable[0][i]));
		    }
		    if (jlbN[0][intOffset + i] != null) {
			jlbN[0][intOffset + i].setFont(fntExample);
			jplGuess[intGuessIndex[i]].add(jlbN[0][intOffset + i]);
		    }			
		    l++;
		    intBegin = 1;
		}
		for (int j = intBegin; j < blnType.length; j++) {
		    if (blnType[j]) {
			jlbT[k][intOffset + i] = new JLabel(strMatch[i].substring(intTable[k][i], intTable[k][i] + 1));
			jlbT[k][intOffset + i].setFont(fntExample);
			jplGuess[intGuessIndex[i]].add(jlbT[k][intOffset + i]);
			k++;
		    } else {
			if (intTable[k][i] == Integer.MAX_VALUE) {
			    if (intTable[k - 1][i] == strMatch[i].length() - 1) {
				jlbN[l][intOffset + i] = null;
			    } else {
				jlbN[l][intOffset + i] = new JLabel(strMatch[i].substring(intTable[k - 1][i] + 1));
			    }
			} else {
			    if (intTable[k][i] - intTable[k - 1][i] == 1) {
				jlbN[l][intOffset + i] = null;
			    } else {
				jlbN[l][intOffset + i] = 
				    new JLabel(strMatch[i].substring(intTable[k - 1][i] + 1, intTable[k][i]));
			    }
			}
			if (jlbN[l][intOffset + i] != null) {
			    jlbN[l][intOffset + i].setFont(fntExample);
			    jplGuess[intGuessIndex[i]].add(jlbN[l][intOffset + i]);
			}			
			l++;
		    }
		}
		jbtGuess[intGuessIndex[i]].setText(strMatch[i]);
	    }
	    intOffset = strMatch.length;
	    for (int i = 0; i < strNotMatch.length; i++) {
		JLabel jlbPlain = new JLabel(strNotMatch[i]);
		jlbPlain.setFont(fntExample);
		jplGuess[intGuessIndex[intOffset + i]].add(jlbPlain);
		jbtGuess[intGuessIndex[intOffset + i]].setText(strNotMatch[i]);
	    }
	}

	jpcContentPane.revalidate();
    }

    protected void buildAnimation() {
	amtThis.removeAll();
	int intBaseTime = ANIMATION_BASE_TIME + strExample.length * ANIMATION_SENTENCE_TIME;
	
	float fltAnim = rand.nextFloat();
	// fltAnim = 0.9f;
	
	if (fltAnim < 0.4) {
	    Animator.Animation anmAdd = null;
	    int intTime = intBaseTime, intOffset = ANIMATION_OFFSET;
	    for (int i = 0; i < jlbPatternT.length; i++) {
		anmAdd = amfThis.createFlyingLabels(jlbT[i], jlbPatternT[i], clrT, intOffset, intTime);
		amtThis.add(anmAdd);
		intOffset += intTime + ANIMATION_OFFSET;
	    }
	    for (int i = 0; i < jlbPatternN.length; i++) {
		anmAdd = amfThis.createFlyingLabels(jlbN[i], jlbPatternN[i], clrN, intOffset, intTime);
		amtThis.add(anmAdd);
		intOffset += intTime + ANIMATION_OFFSET;
	    }
	} else if (fltAnim < 0.8) {
	    boolean[] blnType = bnsExample.getResultType();
	    int i =0, j = 0;
	    int intTime = intBaseTime, intOffset = ANIMATION_OFFSET;
	    Animator.Animation anmAdd = null;
	    for (int k = 0; k < blnType.length; k++) {
		if (blnType[k]) {
		    anmAdd = amfThis.createFlyingLabels(jlbT[i], jlbPatternT[i], clrT, intOffset, intTime);
		    i++;
		} else {
		    anmAdd = amfThis.createFlyingLabels(jlbN[j], jlbPatternN[j], clrN, intOffset, intTime);
		    j++;
		}
		amtThis.add(anmAdd);
		intOffset += intTime + ANIMATION_OFFSET;
	    }		    
	} else if (fltAnim < 0.95) {
	    Animator.Animation anmAdd = null;
	    int intTime = (jlbPatternT.length > 0)?2 * intBaseTime:intBaseTime, intOffset = ANIMATION_OFFSET;	    
	    for (int i = 0; i < jlbPatternT.length; i++) {
		anmAdd = amfThis.createFlyingLabels(jlbT[i], jlbPatternT[i], clrT, intOffset, intTime);
		amtThis.add(anmAdd);
	    }
	    if (jlbPatternT.length > 0) intOffset += intTime + ANIMATION_OFFSET;
	    for (int i = 0; i < jlbPatternN.length; i++) {
		anmAdd = amfThis.createFlyingLabels(jlbN[i], jlbPatternN[i], clrN, intOffset, intTime);
		amtThis.add(anmAdd);
	    }
	} else {
	    Animator.Animation anmAdd = null;
	    int intTime = (jlbPatternT.length > 0)?3 * intBaseTime:intBaseTime, intOffset = ANIMATION_OFFSET;	    
	    for (int i = 0; i < jlbPatternT.length; i++) {
		anmAdd = amfThis.createFlyingLabels(jlbT[i], jlbPatternT[i], clrT, intOffset, intTime);
		amtThis.add(anmAdd);
	    }
	    for (int i = 0; i < jlbPatternN.length; i++) {
		anmAdd = amfThis.createFlyingLabels(jlbN[i], jlbPatternN[i], clrN, intOffset, intTime);
		amtThis.add(anmAdd);
	    }
	}
    }

    protected void buildCorrectGuessAnimation() {
	amtThis.removeAll();

	/*
	// correct
	sanCorrect = new AnimationFactory.StringAnimation[2];
	String strCorrect = "Richtig";
	Font fntNinety = amfThis.getFontForWidth(strCorrect, fntGuessOutcome, 75);
	sanCorrect[0] = amfThis.createStringGrowIn
	    (strCorrect, CORRECT_CLR, fntNinety, 0);
	sanCorrect[1] = amfThis.createStringRotateOut
	    (strCorrect, CORRECT_CLR, fntNinety, sanCorrect[0].getRunningTime());
	*/

	amtThis.add(sanCorrect[0]);
	amtThis.add(sanCorrect[1]);
    }

    protected void buildIncorrectGuessAnimation() {
	amtThis.removeAll();

	/*
	// incorrect
	sanIncorrect = new AnimationFactory.StringAnimation[2];
	String strIncorrect = "Falsch";
	Font fntNinety = amfThis.getFontForWidth(strIncorrect, fntGuessOutcome, 75);
	sanIncorrect[0] = amfThis.createStringFallIn
	    (strIncorrect, INCORRECT_CLR, fntNinety, 0);
	sanIncorrect[1] = amfThis.createStringDropOut
	    (strIncorrect, INCORRECT_CLR, fntNinety, sanIncorrect[0].getRunningTime());
	*/

	amtThis.add(sanIncorrect[0]);
	amtThis.add(sanIncorrect[1]);
    }

    protected void random() {
	intState = RANDOM;
	setRandomExample();
	lngTimedOut = System.currentTimeMillis() + GUESS_TIME;
	timerStep();

	cdlExamplePane.show(jplExamplePane, EXAMPLE);
	cdlPatternPane.show(jplPatternPane, TIMER);
	cdlGuessPane.show(jplGuessPane, GUESS_CHOICE);
	if (!blnPause) {
	    tmrWait.start();
	} else {
	    lngPausedTimeMillis = lngTimedOut - GUESS_TIME;
	}
    }

    protected void guess(int intGuess) {
	intState = GUESS_ANIMATION;
	this.intGuess = intGuess;
	if (tmrWait.isRunning()) tmrWait.stop();
	//	Color clrGuess;
	if (intGuess == intCorrectGuess) {
	    buildCorrectGuessAnimation();
	    //	    clrGuess = CORRECT_CLR;
	} else {
	    buildIncorrectGuessAnimation();
	    //	    clrGuess = INCORRECT_CLR;
	}
	jplGuess[intGuess].setBackground(GUESS_CLR);
	
	cdlExamplePane.show(jplExamplePane, EXAMPLE);	    
	cdlPatternPane.show(jplPatternPane, EMPTY);
	cdlGuessPane.show(jplGuessPane, GUESS);
	amtThis.start();
    }

    protected void guessSolution() {
	jplGuess[intCorrectGuess].setBackground(CORRECT_CLR);
	if (intCorrectGuess != intGuess) jplGuess[intGuess].setBackground(INCORRECT_CLR);
	
	cdlExamplePane.show(jplExamplePane, EXAMPLE);	    
	cdlPatternPane.show(jplPatternPane, PATTERN);
	cdlGuessPane.show(jplGuessPane, GUESS);
	animate();
    }

    protected void animate() {
	intState = ANIMATION;
	if (tmrWait.isRunning()) tmrWait.stop();
	if (tmrIdle.isRunning()) tmrIdle.stop();

	for (int i = 0; i < jlbT.length; i++) for (int j = 0; j < jlbT[i].length; j++)  
	    jlbT[i][j].setForeground(clrBright);
	for (int i = 0; i < jlbN.length; i++) for (int j = 0; j < jlbN[i].length; j++)  
	    if (jlbN[i][j] != null) jlbN[i][j].setForeground(clrBright);

	jpcContentPane.validate();
	//	layout();

	buildAnimation();
	amtThis.start();
    }

    protected void idle() {
	intState = IDLE;
	if (!blnPause) tmrIdle.start();
    }

    protected void interrupt() {
	if (intState != USER) {
	    intState = USER;
	    if (tmrWait.isRunning()) tmrWait.stop();
	    cdlPatternPane.show(jplPatternPane, EMPTY);
	    cdlGuessPane.show(jplGuessPane, EMPTY);
	}	    
	if (tmrIdle.isRunning()) tmrIdle.restart();
	else tmrIdle.start();
    }

    protected String[] filterExample(String[] strNew) {
	String[] strFiltered = null;

	// Filtere neuen string
	int j = 0;
	int intMaxLength = 0;
	for (int i = 0; i < strNew.length; i++) {
	    int intLength = strNew[i].length();
	    if (intLength > 0) {
		j++;
		if (intLength > intMaxLength) intMaxLength = intLength;
	    }
	}
	if (
	    (j > 0) && (j == strNew.length) && (j <= NUMBER_OF_EXAMPLES) && 
	    (intMaxLength <= MAX_EXAMPLE_LENGTH)
	) {
	    strFiltered = strNew;	
	} else if (j > 0) {
	    boolean blnWarn = false;
	    String strWarning = "Folgende Probleme sind aufgetreten:\n";
	    if (j < strNew.length) {
		strWarning += "- Die Eingabe enthlt leere Stze.\n"
		    + "   Die leeren Stze werden entfernt.\n";
	    }
	    if (j > NUMBER_OF_EXAMPLES) {
		strWarning += "- Die Eingabe besteht aus " + strNew.length + " Stzen.\n"
		    + "   Es werden aber nur die ersten " + NUMBER_OF_EXAMPLES + " Stze verarbeitet.\n";
		j = 10;
		blnWarn = true;
	    }
	    if (intMaxLength > MAX_EXAMPLE_LENGTH) {
		strWarning += "- Manche Stze sind lnger als " + MAX_EXAMPLE_LENGTH + " Zeichen.\n"
		    + "   Die Stze werden nur bis zum " + MAX_EXAMPLE_LENGTH + " Zeichen verarbeitet.\n";
		blnWarn = true;
	    }		
	    if (blnWarn) displayWarning(strWarning);

	    strFiltered = new String[j];
	    j = 0;
	    for (int i = 0; j < strFiltered.length; i++) {
		if (strNew[i].length() > MAX_EXAMPLE_LENGTH) {
		    strFiltered[j++] = strNew[i].substring(0, MAX_EXAMPLE_LENGTH);
		    //		    System.out.println(j + ". " + strFiltered[j - 1]);
		} else if (strNew[i].length() > 0) {
		    strFiltered[j++] = strNew[i];
		    //		    System.out.println(j + ". " + strFiltered[j - 1]);
		}
	    }
	} else {
	    String strWarning = "Folgende Probleme sind aufgetreten:\n"
		+ "- Das neue Beispiel ist leer. Das alte Beispiel wird weiterverwendet.";
	    displayWarning(strWarning);

	    strFiltered = this.strExample;
	}
	return strFiltered;
    }

    protected void startBonsaiRec() {
	//	return;
	//	/*
	BonsaiRec.halt();
	String strCSS = "";
	String[] strTmp = bnsExample.getResultPattern();
	for (int i = 0; i < strTmp.length; i++) strCSS += strTmp[i];
	println("start recursive search");
	BonsaiRec.process(this, bnsExample.getData(), strCSS);
	//	*/
    }	

    protected void setRandomExample() {
	println();
	println("generate random example");

	pgnGuess.generatePattern();
	String[] strPattern = pgnGuess.getPattern();
	pgnGuess.generateExample(strPattern);
	this.strExample = pgnGuess.getExample();
	println("start greedy search");
	this.bnsExample.process(cloneExample());
	println("found pattern is \"" + bnsExample.getResult() + "\"");

	startBonsaiRec();

	strPattern = bnsExample.getResultPattern();
	intGuessIndex = pgnGuess.generateRandomOrder(NUMBER_OF_GUESSES);
	if (rand.nextDouble() < 0.5) {
	    pgnGuess.generateExample(strPattern, 1);
	    this.strMatch = pgnGuess.getExample();
	    this.strNotMatch = pgnGuess.generateCounterExample
		(strPattern, bnsExample.getPattern(), NUMBER_OF_GUESSES - 1);
	    intCorrectGuess = intGuessIndex[0];
	    jlbGuessChoiceHead.setText("Welche Zeichenfolge passt zu den Beispielen?");
	    jlbGuessDisplayHead.setText("Welche Zeichenfolge passt zu den Beispielen?");
	} else {
	    pgnGuess.generateExample(strPattern, NUMBER_OF_GUESSES - 1);
	    this.strMatch = pgnGuess.getExample();
	    this.strNotMatch = pgnGuess.generateCounterExample
		(strPattern, bnsExample.getPattern(), 1);
	    intCorrectGuess = intGuessIndex[NUMBER_OF_GUESSES - 1];
	    jlbGuessChoiceHead.setText("Welche Zeichenfolge passt nicht zu den Beispielen?");
	    jlbGuessDisplayHead.setText("Welche Zeichenfolge passt nicht zu den Beispielen?");
	}
	println("the correct answer is " + ABC[intCorrectGuess]);
	buildResult();
	jpcContentPane.repaint();
    }

    protected void setUserExample(String[] strUserExample) {
	println();
	println("process user example");

	this.strExample = filterExample(strUserExample);
	println("start greedy search");
	this.bnsExample.process(cloneExample());
	println("found pattern is \"" + bnsExample.getResult() + "\"");

	startBonsaiRec();

	this.strMatch = null;
	this.strNotMatch = null;
	buildResult();
	cdlExamplePane.show(jplExamplePane, EXAMPLE);	    
	cdlPatternPane.show(jplPatternPane, PATTERN);
	cdlGuessPane.show(jplGuessPane, EMPTY);
	jpcContentPane.repaint();

	animate();
    }
    
    protected String[] cloneExample() {
	String[] strClone = new String[this.strExample.length];
	for (int i = 0; i < this.strExample.length; i++) strClone[i] = new String(this.strExample[i]);
	return strClone;
    }

    protected final void displayWarning(String strWarning) {
	JOptionPane.showMessageDialog(jpcContentPane, strWarning, "Warnung", JOptionPane.WARNING_MESSAGE);
    }


    // Animator.Listener
    protected void animationEnded() {
	switch (intState) {
	case BEGIN:
	    random();
	    break;
	case GUESS_ANIMATION:
	    guessSolution();
	    break;
	default:
	    idle();
	}
    }	

    public void animationFinnished(Animator.Animation anmEnd) {
	//	System.out.println("Animation ended");
    }

    public void animatorFinnished() {	
	//	System.out.println("Animator finnished");
	animationEnded();
    }

    public void animatorStopped() {
	//	System.out.println("Animator stopped");
	animationEnded();
    }


    java.util.List lstInfo = new ArrayList(64);
    int intInfoSize;
    public void println(String strPrint) {
	//	return;
	//	/*
	//	jtaInfo.append("> " + strPrint + "\n");

	lstInfo.add("> " + strPrint + "\n");
	intInfoSize += strPrint.length() + 3;
	updateInfo();
	//	*/
    }

    public void println() {
	//	/*
	lstInfo.add(">\n");
	intInfoSize += 2;
	updateInfo();
	//	*/
    }

    public void updateInfo() {
	while (lstInfo.size() > 12) {
	    String strRemove = (String)lstInfo.remove(0);
	    intInfoSize -= strRemove.length();
	}
	StringBuffer stbInfo = new StringBuffer(intInfoSize);
	Iterator iteInfo = lstInfo.iterator();
	while (iteInfo.hasNext()) stbInfo.append((String)iteInfo.next());

	jtaInfo.setText(stbInfo.toString());
	jtaInfo.repaint();
    }





    public static void main(String[] args) {
	BonsaiGUI bgiThis = new BonsaiGUI();
	JFrame jfrBonsai = new JFrame(bgiThis.getName());
	jfrBonsai.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	jfrBonsai.setResizable(false);
	jfrBonsai.setContentPane((JComponent)bgiThis.getComponent());
	jfrBonsai.pack();
	jfrBonsai.setVisible(true);
	bgiThis.init();
	bgiThis.start();
    }

}
