/*
BonsaiRec
Copyright (C) 2003 Bj\"orn Hoffmeister

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package de.uni_luebeck.tcs.demo.datamining;

import java.util.*;
import java.util.regex.*;

public class BonsaiRec extends Thread {
    protected String[] strSource;
    protected String strS;
    protected int intS;

    protected char[] chrC;
    protected int intC;

    protected StringBuffer stbLCSS;
    protected int intLCSS;

    protected int intChecked;

    protected BonsaiGUI bngThis;
    protected boolean blnHalt = false;

    public BonsaiRec(BonsaiGUI bngThis) {
	this.bngThis = bngThis;
    }

    protected void read(String[] strSource) {
	this.strSource = strSource;
	int intMin = strSource[0].length();
	intS = 0;
	for (int i = 1; i < strSource.length; i++) if (strSource[i].length() < intMin) {
	    intMin = strSource[i].length();
	    intS = i;
	}
	this.strS = strSource[intS];
	this.chrC = new char[intMin];
	this.intC = 0;
	this.stbLCSS = new StringBuffer(intMin);
	this.intLCSS = 0;
    }

    protected void recProcess(int n) {
	if (blnHalt) return;

	int intDiff = strS.length() - n;
	if (intDiff == 0) {
	    if (check()) {
		saveNewLCSS();
		debug("found longer subsequence \"" + stbLCSS + "\"");
		//		debug("succeded -> \"" + stbLCSS + "\" ist neues Subwort.");
	    } else {
		//		debug("failed -> \"" + currentSubWord() + "\" ist kein Subwort oder nicht laenger als \"" + stbLCSS + "\".");
	    }
	} else if (intC + intDiff == intLCSS) {
	    //	    debug("failed -> \"" + currentSubWord() + ".{" + intDiff + "}\" kann \"" + stbLCSS + "\" nicht mehr schlagen.");
	} else {
	    chrC[intC++] = strS.charAt(n);
	    recProcess(n + 1);
	    intC--;
	    recProcess(n + 1);
	}
    }

    protected final boolean check() {
	intChecked++;

	if (intC <= intLCSS) return false;
	boolean blnCheck = true;
	for (int i = 0; i < strSource.length; i++) {
	    if (i != intS) if (!matches(strSource[i])) {
		blnCheck = false;
		break;
	    }
	}
	return blnCheck;
    }

    protected final boolean matches(String strMatch) {
	int intLast = -1;
	for (int i = 0; i < intC; i++) {
	    if ((intLast = strMatch.indexOf(chrC[i], intLast + 1)) == -1) break;
	}
	return (intLast > -1);
    }

    protected final void saveNewLCSS() {
	stbLCSS.delete(0, stbLCSS.length());
	for (int i = 0; i < intC; i++) stbLCSS.append(chrC[i]);
	intLCSS = intC;
    }

    protected String currentSubWord() {
	StringBuffer stbCurrentSubWord = new StringBuffer(intC);
	for (int i = 0; i < intC; i++) stbCurrentSubWord.append(chrC[i]);
	return stbCurrentSubWord.toString();
    }

    protected final void debug(String strDebug) {
	bngThis.println(strDebug);
	//	System.out.println(strDebug);
    }
    
    protected int[][] intIndex;
    protected boolean[] blnPatternMask;
    protected String strResult;
    protected String strPattern;
    protected Pattern patResult;
    protected void index() {
	this.intIndex = new int[intC + 1][strSource.length];
	boolean[] blnStucked = new boolean[intC + 1];
	Arrays.fill(blnStucked, true);
	for (int i = 0; i < strSource.length; i++) {
	    intIndex[0][i] = strSource[i].indexOf(chrC[0]);
	    if (intIndex[0][i] > 0) blnStucked[0] = false;
	    for (int j = 1; j < intC; j++) {
		intIndex[j][i] = strSource[i].indexOf(chrC[j], intIndex[j - 1][i] + 1);
		if (intIndex[j][i] - intIndex[j - 1][i] > 1) blnStucked[j] = false;
	    }
	    if (intIndex[intC - 1][i] < strSource[i].length() - 1) blnStucked[intC] = false;
	    intIndex[intC + 1][i] = Integer.MAX_VALUE;
	}

	int intNT = 0;
	for (int i = 0; i < blnStucked.length; i++) if (!blnStucked[i]) intNT++;

	StringBuffer stbPattern = new StringBuffer(intC + intNT);
	StringBuffer stbRegEx = new StringBuffer(intC + 2 * intNT);
	this.blnPatternMask = new boolean[intC + intNT];
	int intPatternMask = 0;
	for (int i = 0; i < intC; i++) {
	    if (!blnStucked[i]) {
		stbPattern.append('x');
		stbRegEx.append(".*");
		blnPatternMask[intPatternMask++] = false;
	    }
	    stbPattern.append(chrC[i]);
	    blnPatternMask[intPatternMask++] = true;
	}
	if (!blnStucked[blnStucked.length - 1]) {
	    stbPattern.append('x');
	    stbRegEx.append(".*");
	    blnPatternMask[intPatternMask++] = false;
	}
	this.strResult = stbLCSS.toString();
	this.strPattern = stbPattern.toString();
	this.patResult = Pattern.compile(stbRegEx.toString());
    }

    public String getResult() {
	return strResult;
    }


    public void start(String[] strSource, String strKnownSubword) {
	if (strSource.length == 1) {
	    strResult = strSource[0];
	    debug("longest subsequence is \"" + strSource[0] + "\"");
	    debug("");
	} else {
	    read(strSource);
	    if (strKnownSubword != null) {
		debug("initialize with \"" + strKnownSubword + "\"");
		stbLCSS.append(strKnownSubword);
		intLCSS = stbLCSS.length();
	    }
	    intChecked = 0;
	    start();
	}
    }

    public void run() {
	//	debug("started");
	recProcess(0);
	if (!blnHalt) {
	    debug(intChecked + " subsequences checked");
	    debug("longest subsequence is \"" + stbLCSS + "\"");
	}
    }    

    protected static BonsaiRec brcThis = null;
    public static void process(BonsaiGUI bgiThis, String[] strSource, String strKnownSubword) {
	if (brcThis != null) brcThis.blnHalt = true;
	brcThis = new BonsaiRec(bgiThis);
	brcThis.setPriority(Thread.MIN_PRIORITY + 1);
	brcThis.setDaemon(true);
	brcThis.start(strSource, strKnownSubword);
    }

    public static void halt() {
	if (brcThis != null) brcThis.blnHalt = true;
    }
	


    /*
    static String strSource;
    static char[] chrC;
    static int intC;
    public static void rec(int n) {
	if (n == strSource.length()) {
	    print();
	} else {
	    chrC[intC++] = strSource.charAt(n);
	    rec(n + 1);
	    intC--;
	    rec(n + 1);
	}
    }

    static void print() {
	for (int i = 0; i < intC; i++) System.out.print(chrC[i]);
	System.out.println();
    }
    */

    protected final static String[] DEFAULT_EXAMPLE = {
	"AKEBONO MUSASHIMARU",
	"CONTRIBUTIONS OF AI",
	"BASED ON LOCAL SEARCH ALGORITHMS",
	"BOOLEAN CLASSIFICATION",
	"SYMBOLIC TRANSFORMATION",
	"BACON SANDWICH",
	"PUBLICATION OF DISSERTATION"
    };
    public static void main(String[] args) {
    }
}
